
#if !defined( glut_content_h )
#define glut_content_h

class IGlutContent {
  public:
    //  implement this for your scene
    virtual void createScene() = 0;
    virtual void step( float deltaTime ) = 0;

    virtual void key( int x, int y, unsigned char key, bool special );
    virtual void beginDrag( int x, int y, unsigned int buttons );
    virtual void dragMove( int x, int y );
    virtual void endDrag( int x, int y );
    virtual void mouseMove( int x, int y );

  protected:
    //  call these to affect the host
    void setDefaultKeyHandling( bool def );
    void setDefaultMouseCamera( bool def );
    void getCamera( float * outXyz, float * outLookAt, float * outHeading );
    void setCamera( float const * xyz, float const heading ); //  camera heading in degrees
};

IGlutContent * MakeGlutContent();

#endif  //  glut_content_h
