
#include "glwrap.h"
#include "internaltexture.h"
#include "glut.h"

#include <stdarg.h>


GWState const GW_PLAIN_STATE(
  TextureRef(),
  GL_MODULATE,
  GL_SRC_ALPHA,
  GL_ONE_MINUS_SRC_ALPHA,
  GWColor( 0xffffffff ),
  0.05f,
  GWTexFrame( 1.f, 1.f, 0.f, 0.f ),
  false,
  false,
  false
);

GWTexFrame const GWTexFrame::unity;

static GWState curState;


void 
gwInit()
{
}

void 
gwSwapBuffers()
{
  //fixme: ==hplus== draw overlay text here
  glutSwapBuffers();
}

void 
gwAddOverlayText( char const * str, ... )
{
  va_list args;
  va_start( args, str );
  gwAddOverlayTextV( str, args );
  va_end( args );
}

void 
gwAddOverlayTextV( char const * str, va_list args )
{
  //fixme: ==hplus== implement me
}


void
gwForceState( GWState const * state )
{
  curState = *state;
  if( curState.texture.consistent() ) {
    glEnable( GL_TEXTURE_2D );
    glBindTexture( GL_TEXTURE_2D, curState.texture.mTexture->mTexId );
  }
  else {
    glDisable( GL_TEXTURE_2D );
  }
  glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, curState.texMode );
  curState.texFrame.apply();
  if( curState.blend ) {
    glEnable( GL_BLEND );
    if( !curState.test ) {
      curState.test = true;
      curState.testLevel = 0.05f;
    }
  }
  else {
    glDisable( GL_BLEND );
  }
  glBlendFunc( curState.blendSrc, curState.blendDst );
  glColor4ub( curState.color.red, curState.color.green, curState.color.blue, curState.color.alpha );
  if( curState.lit ) {
    glEnable( GL_LIGHTING );
  }
  else {
    glDisable( GL_LIGHTING );
  }
  if( curState.test ) {
    glEnable( GL_ALPHA_TEST );
  }
  else {
    glDisable( GL_ALPHA_TEST );
  }
  glAlphaFunc( GL_GREATER, curState.testLevel );

  assert( !glGetError() );
}

void
gwFlushState()
{
  //fixme: could set flag, and use that flag to call gwForceState() in gwSetState()
  gwForceState( &GW_PLAIN_STATE );
}

void
gwSetState( GWState const * state )
{
  if( state->texture != curState.texture ) {
    if( state->texture.consistent() ) {
      glEnable( GL_TEXTURE_2D );
      glBindTexture( GL_TEXTURE_2D, state->texture.mTexture->mTexId );
      if( curState.texMode != state->texMode ) {
        glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, state->texMode );
        curState.texMode = state->texMode;
      }
      curState.texture = state->texture;
    }
    else if( curState.texture != TextureRef::null ) {
      glDisable( GL_TEXTURE_2D );
      curState.texture = TextureRef::null;
    }
  }
  if( state->texFrame != curState.texFrame ) {
    state->texFrame.apply();
    curState.texFrame = state->texFrame;
  }
  if( state->blend != curState.blend ) {
    if( state->blend ) {
      glEnable( GL_BLEND );
      if( state->blendSrc != curState.blendSrc || state->blendDst != curState.blendDst ) {
        glBlendFunc( state->blendSrc, state->blendDst );
        curState.blendSrc = state->blendSrc;
        curState.blendDst = state->blendDst;
      }
    }
    else {
      glDisable( GL_BLEND );
    }
    curState.blend = state->blend;
  }
  if( state->color.color != curState.color.color ) {
    glColor4ub( state->color.red, state->color.green, state->color.blue, state->color.alpha );
    curState.color = state->color;
  }
  if( state->lit != curState.lit ) {
    if( state->lit ) {
      glEnable( GL_LIGHTING );
    }
    else {
      glDisable( GL_LIGHTING );
    }
    curState.lit = state->lit;
  }
  if( state->test != curState.test ) {
    if( state->test ) {
      glEnable( GL_ALPHA_TEST );
      if( state->testLevel != curState.testLevel ) {
        glAlphaFunc( GL_GREATER, state->testLevel );
        curState.testLevel = state->testLevel;
      }
    }
    else {
      glDisable( GL_ALPHA_TEST );
      curState.test = state->test;
    }
    curState.test = state->test;
  }

  assert( !glGetError() );
}

void 
gwTextureCoordTransform( float offsetS, float offsetT, float scaleS, float scaleT )
{
  glMatrixMode( GL_TEXTURE );
  glTranslatef( offsetS, offsetT, 0 );
  glScalef( scaleS, scaleT, 1 );
  glMatrixMode( GL_MODELVIEW );
  curState.texFrame.mOffsetS += offsetS;
  curState.texFrame.mOffsetT += offsetT;
  curState.texFrame.mScaleS *= scaleS;
  curState.texFrame.mScaleT *= scaleT;
}

void
gwGetState( GWState * outState )
{
  *outState = curState;
}

void
gwReset()
{
  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  glMatrixMode( GL_TEXTURE );
  glLoadIdentity();
  glMatrixMode( GL_MODELVIEW );
  glLoadIdentity();
  glDisable( GL_LIGHTING );
  glDisable( GL_TEXTURE_CUBE_MAP );
  glDisable( GL_TEXTURE_3D );
  glDisable( GL_TEXTURE_2D );
  glDisable( GL_TEXTURE_1D );
  glFrontFace( GL_CCW );
  glCullFace( GL_BACK );
  glEnable( GL_CULL_FACE );
  glDisable( GL_DEPTH_TEST );
  glDisable( GL_BLEND );
  glDisable( GL_ALPHA_TEST );
  glDisable( GL_STENCIL_TEST );

  assert( !glGetError() );

  gwFlushState();
}

