
#if !defined( glwrap_h )
#define glwrap_h

#include "glut-start.h"

#include <GL/GL.h>
#include "myext.h"

#include "textures.h"



union GWColor {
  GWColor( ) { }
  GWColor( unsigned int c ) : color( c ) { }
  GWColor( unsigned char a, unsigned char r, unsigned char g, unsigned char b ) : blue( b ), green( g ), red( r ), alpha( a ) { }
//fixme:  this is only true for little-endian platform
  struct {
    unsigned char   blue;
    unsigned char   green;
    unsigned char   red;
    unsigned char   alpha;
  };
  unsigned int      color;

  bool operator==( GWColor const & o ) const
            {
              return color == o.color;
            }
  bool operator!=( GWColor const & o ) const
            {
              return color == o.color;
            }
};

struct GWTexFrame {
  GWTexFrame( float scaleS, float scaleT, float offsetS, float offsetT )
    : mScaleS( scaleS )
    , mScaleT( scaleT )
    , mOffsetS( offsetS )
    , mOffsetT( offsetT )
    {
    }
  GWTexFrame( )
    : mScaleS( 1.f )
    , mScaleT( 1.f )
    , mOffsetS( 0.f )
    , mOffsetT( 0.f )
    {
    }
  bool operator==( GWTexFrame const & o ) const
    {
      return (mScaleS == o.mScaleS) && (mScaleT == o.mScaleT) && 
          (mOffsetS == o.mOffsetS) && (mOffsetT == o.mOffsetT);
    }
  bool operator!=( GWTexFrame const & o ) const
    {
      return !(*this == o );
    }
  void apply( ) const
    {
      glMatrixMode( GL_TEXTURE );
      if( *this == unity ) {
        glLoadIdentity( );
      }
      else {
        static GLfloat f[ 16 ] = {
          0.f, 0.f, 0.f, 0.f,
          0.f, 0.f, 0.f, 0.f,
          0.f, 0.f, 0.f, 0.f,
          0.f, 0.f, 0.f, 1.f,
        }; //  will stay initialized to zeros where we don't use it!
        f[ 0 ] = mScaleS;
        f[ 5 ] = mScaleT;
        f[ 12 ] = mOffsetS;
        f[ 13 ] = mOffsetT;
        glLoadMatrixf( f );
      }
      glMatrixMode( GL_MODELVIEW );
    }
  static GWTexFrame const unity;

  float mScaleS;
  float mScaleT;
  float mOffsetS;
  float mOffsetT;
};

struct GWState;

extern GWState const GW_PLAIN_STATE;

struct GWState {
  GWState( GWState const & o = GW_PLAIN_STATE ) : 
    texture( o.texture ), texMode( o.texMode ), blendSrc( o.blendSrc ), blendDst( o.blendDst ), 
    color( o.color ), testLevel( o.testLevel ), texFrame( o.texFrame ),
    lit( o.lit ), blend( o.blend ), test( o.test )
    {
    }
  GWState( TextureRef const & tr, GLenum tm, GLenum bs, GLenum bd, GWColor c, float ml, 
      GWTexFrame const & tf, bool l, bool b, bool t ) :
    texture( tr ), texMode( tm ), blendSrc( bs ), blendDst( bd ), 
    color( c ), testLevel( ml ), texFrame( tf ), 
    lit( l ), blend( b ), test( t )
    {
    }
  GWState const & operator=( GWState const & o )
    {
      texture = o.texture;
      texMode = o.texMode;
      blendSrc = o.blendSrc;
      blendDst = o.blendDst;
      color = o.color;
      testLevel = o.testLevel;
      texFrame = o.texFrame;
      lit = o.lit;
      blend = o.blend;
      test = o.test;
      return *this;
    }
  //todo: Factor out mode/combine/color into a more flexible block 
  //      and use a pointer to it. Provide defaults for REPLACE, 
  //      MODULATE, etc.
  //      Pehaps also for blending, alpha testing, etc.
  TextureRef        texture;
  GLenum            texMode;
  GLenum            blendSrc;
  GLenum            blendDst;
  GWColor           color;
  float             testLevel;
  GWTexFrame        texFrame;
  bool              lit;
  bool              blend;
  bool              test;
};

void gwInit();
void gwSwapBuffers();
void gwAddOverlayText( char const * str, ... );
void gwAddOverlayTextV( char const * str, va_list args );
void gwForceState( GWState const * state );
void gwFlushState();
void gwSetState( GWState const * state );
void gwGetState( GWState * outState );
void gwReset();
void gwTextureCoordTransform( float offsetS, float offsetT, float scaleS, float scaleT );


#endif  //  glwrap_h
