
#include "log.h"


static FILE * sLogFile;
static int sFilterLevel;
static void (*warnFunc)( char const *, va_list );

void initLog( char const * name, int level, void (*f)( char const *, va_list ) )
{
  warnFunc = f;
  if( sLogFile ) {
    fclose( sLogFile );
  }
  sLogFile = fopen( name, "wb" );
  assert( sLogFile );
  if( sLogFile ) {
    char now[ 100 ];
    time_t t;
    time( &t );
    struct tm n = *localtime( &t );
    strftime( now, 100, "%Y-%m-%d %H:%M:%S", &n );
    fprintf( sLogFile, "# build %s log file %s created %s\n", 
#if !defined( NDEBUG )
      "DEBUG " __DATE__ " " __TIME__,
#else
      "RELEASE " __DATE__ " " __TIME__,
#endif      
      name, 
      now );
    fflush( sLogFile );
  }
  sFilterLevel = level;
}


static char const * sLevelNames[] = {
  "ERR: ",//LogFilterError,
  "WRN: ",//LogFilterWarning,
  "NFO: ",//LogFilterInfo,
  "DBG: ",//LogFilterDebug,
};

static void
addToLog( int level, char const * fmt, va_list args )
{
  assert( level >= LogFilterError && level < LogFilterNone );
  assert( level < sizeof(sLevelNames)/sizeof(sLevelNames[0]) );
  if( sFilterLevel <= level || !sLogFile ) return;
  if( warnFunc && (level <= 1) ) {
    (*warnFunc)( fmt, args );
  }
  fprintf( sLogFile, sLevelNames[ level ] );
  vfprintf( sLogFile, fmt, args );
  fflush( sLogFile );
}

#define LOG(f,l) \
  va_list v; \
  va_start( v, f ); \
  addToLog( l, f, v ); \
  va_end( v )

void error( char const * fmt, ... )
{
  LOG( fmt, LogFilterError );
}

void warning( char const * fmt, ... )
{
  LOG( fmt, LogFilterWarning );
}

void info( char const * fmt, ... )
{
  LOG( fmt, LogFilterInfo );
}

void debug( char const * fmt, ... )
{
  LOG( fmt, LogFilterDebug );
}

