
#include "glut-start.h"

#include "glwrap.h"
#include "glut.h"
#include "myext.h"

#include "glut-content.h"

#include <string.h>


IGlutContent * g_content;
bool g_defaultKeyHandling = true;
bool g_defaultMouseCamera = true;
float g_cameraXyz[ 3 ];
float g_cameraLookAt[ 3 ];
float g_cameraHeading;  //  degrees
float g_cameraPitch;    //  degrees
float WINWIDTH = 640;
float WINHEIGHT = 480;
float ASPECT = float(WINHEIGHT)/float(WINWIDTH);

__int64 g_lastTime;
double g_frequency;

void initCamera()
{
  g_cameraXyz[0] = 0;
  g_cameraXyz[1] = 2;
  g_cameraXyz[2] = 10;
  g_cameraLookAt[0] = 0;
  g_cameraLookAt[1] = 2;
  g_cameraLookAt[2] = 9;
  g_cameraHeading = 0;
  g_cameraPitch = 0;
}

void updateCameraHeading()
{
  g_cameraLookAt[0] = -float( sin( g_cameraHeading * 3.14159265358979 / 180 ) )+g_cameraXyz[0];
  g_cameraLookAt[1] = g_cameraXyz[1];
  g_cameraLookAt[2] = -float( cos( g_cameraHeading * 3.14159265358979 / 180 ) )+g_cameraXyz[2];
}

void IGlutContent::setDefaultKeyHandling( bool def )
{
  g_defaultKeyHandling = def;
}

void IGlutContent::setDefaultMouseCamera( bool def )
{
  g_defaultMouseCamera = def;
}

void IGlutContent::mouseMove( int, int )
{
}
void IGlutContent::endDrag( int, int )
{
}
void IGlutContent::dragMove( int, int )
{
}
void IGlutContent::beginDrag( int, int, unsigned int )
{
}
void IGlutContent::key( int, int, unsigned char, bool )
{
}

void getCamera( float * outXyz, float * outLookAt, float * outHeading, float * outPitch )
{
  memcpy( outXyz, g_cameraXyz, sizeof( g_cameraXyz ) );
  memcpy( outLookAt, g_cameraLookAt, sizeof( g_cameraLookAt ) );
  *outHeading = g_cameraHeading;
  *outPitch = g_cameraPitch;
}

void setCamera( float const * xyz, float const heading, float const pitch )
{
  memcpy( g_cameraXyz, xyz, sizeof( g_cameraXyz ) );
  g_cameraHeading = heading;
  g_cameraPitch = pitch;
  updateCameraHeading();
}

struct IntOptionValue {
  char const * name;
  int val;
};
static IntOptionValue intValues[] = {
  { "winSizeX", int(WINWIDTH) },
  { "winSizeY", int(WINHEIGHT) },
};

int
intOption( char const * o )
{
  for( int ix = 0; ix < sizeof(intValues)/sizeof(intValues[0]); ++ix ) {
    if( !_stricmp( intValues[ix].name, o ) ) {
      return intValues[ix].val;
    }
  }
  assert( 0 );
  return -1;
}

static void
vanillaGl()
{
  gwReset();

  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  glFrustum( -0.5, 0.5, -ASPECT*0.5, ASPECT*0.5, 1, 5000 );
  glMatrixMode( GL_MODELVIEW );
  glLoadIdentity();

  assert( !glGetError() );
}




void display()
{
  vanillaGl();
  glClearDepth( 1 );
  glClearColor( 0, 1, 1, 0 );
  glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

  updateCameraHeading();
  glRotatef( -g_cameraPitch, 1, 0, 0 );
  glRotatef( -g_cameraHeading, 0, 1, 0 );
  glTranslatef( -g_cameraXyz[0], -g_cameraXyz[1], -g_cameraXyz[2] );

  __int64 now;
  QueryPerformanceCounter( (LARGE_INTEGER *)&now );
  now -= g_lastTime;
  g_lastTime += now;
  double deltaTime = g_frequency * (long)now;
  g_content->step( float( deltaTime ) );

  assert( !glGetError() );
  gwSwapBuffers();
}


bool options[ 128 ];

static void
putOptions( int argc, char ** argv )
{
  for( int ix = 0; ix < argc; ++ix ) {
    if( argv[ix][0] == '-' && argv[ix][1] != '-' ) {
      char * p = &argv[ix][1];
      while( *p ) {
        options[*p & 0x7f] = true;
        ++p;
      }
    }
    else {
      char * eq = strchr( argv[ ix ], '=' );
      if( eq ) {
        *eq = 0;
        ++eq;
        for( int o = 0; o < sizeof(intValues)/sizeof(intValues[0]); ++o ) {
          if( !stricmp( intValues[o].name, argv[ix] ) ) {
            intValues[o].val = atoi(eq);
            printf( "setting %s to %d\n", intValues[o].name, intValues[o].val );
            goto foundit;
          }
        }
      }
      printf( "unknown option: %s\n", argv[ix] );
foundit:
      ;
    }
  }
}

bool
hasOption( char ch )
{
  return options[ ch & 0x7f ];
}

void keyboard( unsigned char key, int x, int y )
{
  g_content->key( x, y, key, false );
  if( g_defaultKeyHandling ) {
    switch( key ) {
      case 27:
        exit( 1 );
        break;
      case 'r':
        initCamera();
        break;
    }
  }
}

void special( int key, int x, int y )
{
  g_content->key( x, y, key, true );
  if( g_defaultKeyHandling ) {
    if( key == GLUT_KEY_UP ) {
      g_cameraXyz[0] += (g_cameraLookAt[0]-g_cameraXyz[0]);
      g_cameraXyz[1] += (g_cameraLookAt[1]-g_cameraXyz[1]);
      g_cameraXyz[2] += (g_cameraLookAt[2]-g_cameraXyz[2]);
      updateCameraHeading();
    }
    else if( key == GLUT_KEY_DOWN ) {
      g_cameraXyz[0] -= (g_cameraLookAt[0]-g_cameraXyz[0]);
      g_cameraXyz[1] -= (g_cameraLookAt[1]-g_cameraXyz[1]);
      g_cameraXyz[2] -= (g_cameraLookAt[2]-g_cameraXyz[2]);
      updateCameraHeading();
    }
    else if( key == GLUT_KEY_RIGHT ) {
      //  assume we're using Y = up
      g_cameraXyz[0] -= (g_cameraLookAt[2]-g_cameraXyz[2]);
      g_cameraXyz[2] += (g_cameraLookAt[0]-g_cameraXyz[0]);
      updateCameraHeading();
    }
    else if( key == GLUT_KEY_LEFT ) {
      //  assume we're using Y = up
      g_cameraXyz[0] += (g_cameraLookAt[2]-g_cameraXyz[2]);
      g_cameraXyz[2] -= (g_cameraLookAt[0]-g_cameraXyz[0]);
      updateCameraHeading();
    }
  }
}

void timer()
{
  glutPostRedisplay();
}

int g_dragX;
int g_dragY;
bool g_inDrag;

void mouse( int button, int state, int x, int y )
{
  if( g_defaultMouseCamera ) {
    g_dragX = x;
    g_dragY = y;
  }
  else {
    if( state == GLUT_DOWN ) {
      if( !g_inDrag ) {
        g_inDrag = true;
        g_content->beginDrag( x, y, 1U<<button );
      }
    }
    else if( g_inDrag ) {
      g_inDrag = false;
      g_content->endDrag( x, y );
    }
  }
}

void activeMotion( int x, int y )
{
  if( g_defaultMouseCamera ) {
    if( x != g_dragX ) {
      g_cameraHeading += (g_dragX - x);
      if( g_cameraHeading > 180 ) {
        g_cameraHeading -= 360;
      }
      else if( g_cameraHeading < -180 ) {
        g_cameraHeading += 180;
      }
      g_dragX = x;
    }
    if( y != g_dragY ) {
      g_cameraPitch += (g_dragY - y);
      if( g_cameraPitch > 75 ) {
        g_cameraPitch = 75;
      }
      else if( g_cameraPitch < -75 ) {
        g_cameraPitch = -75;
      }
      g_dragY = y;
    }
  }
  else if( g_inDrag ) {
    g_content->dragMove( x, y );
  }
  else {
    g_content->mouseMove( x, y );
  }
}

void passiveMotion( int x, int y )
{
  if( g_inDrag ) {
    g_inDrag = false;
    g_content->endDrag( x, y );
  }
  else {
    g_content->mouseMove( x, y );
  }
}

void
goBackToNormalScreen()
{
  ChangeDisplaySettings( 0, 0 );
}

int main(int argc, char** argv)
{
#if !defined( NDEBUG )
  initLog( "log.txt", LogFilterNone, gwAddOverlayTextV );
#else
  initLog( "log.txt", LogFilterDebug, gwAddOverlayTextV );
#endif

  RECT r = { 0, 0, 0, 0 };
  AdjustWindowRectEx( &r, WS_OVERLAPPEDWINDOW, false, WS_EX_OVERLAPPEDWINDOW );
  
  putOptions( argc, argv );
  glutInit(&argc, argv);
  glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH );
  WINWIDTH = float( intOption( "winSizeX" ) );
  WINHEIGHT = float( intOption( "winSizeY" ) );
  ASPECT = WINHEIGHT/WINWIDTH;
  glutInitWindowSize(int(WINWIDTH),int(WINHEIGHT));
  if( !options['w'] ) {
// this doesn't seem to work -- can't find documentation anywhere
//    glutGameModeString( "800x600@60" );
//    glutEnterGameMode();
    glutInitWindowPosition(0, 0);
  }
  else {
    glutInitWindowPosition(100, 0);
  }
  glutCreateWindow("Main Window");
  glutSetKeyRepeat( GLUT_KEY_REPEAT_OFF );
  //  -w for full-screen
  if( options[ 'w' ] ) {
    DEVMODE dm;
    memset( &dm, 0, sizeof( dm ) );
    dm.dmSize = sizeof( DEVMODE );
    dm.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT;
    dm.dmBitsPerPel = 32;
    dm.dmPelsWidth = int(WINWIDTH);
    dm.dmPelsHeight = int(WINHEIGHT);
    dm.dmDisplayFlags = 0;
    dm.dmDisplayFrequency = 60;
    BOOL b = ChangeDisplaySettings( &dm, CDS_FULLSCREEN );
    if( !b ) {
      error( "ChangeDisplaySettings(): cannot go fullscreen!\n" );
    }
    atexit( goBackToNormalScreen );
    glutPositionWindow( 0, 0 );
    glutReshapeWindow( int(WINWIDTH), int(WINHEIGHT) );
  }
  initCamera();
  gwInit();
  g_content = MakeGlutContent();
  g_content->createScene();
  vanillaGl();
  gwFlushState();
  glutDisplayFunc( display );
  glutKeyboardFunc( keyboard );
  glutSpecialFunc( special );
  glutIdleFunc( timer );
  glutMouseFunc( mouse );
  glutMotionFunc( activeMotion );
  glutPassiveMotionFunc( passiveMotion );

  QueryPerformanceFrequency( (LARGE_INTEGER *)&g_lastTime );
  g_frequency = 1.0 / (long)g_lastTime;
  QueryPerformanceCounter( (LARGE_INTEGER *)&g_lastTime );

  glutMainLoop();

  return 0;
}


static int
splitCmdLine( char const * cmdLine, char ** argv, int n )
{
  int args = 0;
  while( n > 1 ) {
    while( *cmdLine && isspace( *cmdLine ) ) {
      ++cmdLine;
    }
    if( !*cmdLine ) break;
    char const * lStart;
    char const * lEnd;
    if( *cmdLine == '\"' ) {
      lStart = cmdLine+1;
      lEnd = strchr( lStart, '\"' );
    }
    else {
      lStart = cmdLine;
      lEnd = strchr( lStart, ' ' );
    }
    if( !lEnd ) {
      lEnd = lStart + strlen( lStart );
    }
    *argv = new char[ lEnd-lStart+1 ];
    memcpy( *argv, lStart, lEnd-lStart );
    (*argv)[ lEnd-lStart ] = 0;
    --n;
    ++args;
    ++argv;
    if( *lEnd ) {
      cmdLine = lEnd+1;
    }
    else {
      cmdLine = lEnd;
    }
  }
  *argv = 0;
  return args;
}

int __stdcall
WinMain(
  HINSTANCE cur,
  HINSTANCE prev,
  LPSTR     cmdLine,
  int       cmdShow )
{
  char * argv[ 100 ];
  char progName[ 32 ] = "glut-start";
  argv[ 0 ] = progName;
  int argc = 1 + splitCmdLine( cmdLine, &argv[ 1 ], 98 );
  return main( argc, argv );
}


int 
strcasecmp( char const * a, char const * b )
{
  while( *a && *b && (tolower(*a) == tolower(*b)) ) {
    ++a;
    ++b;
  }
  return *a - *b;
}

