
#include "scratch.h"


static char sScratchSpace[ ScratchSizeMax + 128 ];
static char * sScratch = &sScratchSpace[ (128-((unsigned long)sScratchSpace & 127))&127 ];
static long sScratchTop;

StackScratch::StackScratch( ) :
  mTotal( 0 )
{
}

StackScratch::~StackScratch( )
{
  sScratchTop -= mTotal;
}

void *
StackScratch::get( long l )
{
  //  round to a cache line
  l = (l + 127) & -128;
  assert( l <= ScratchSizeMax-sScratchTop );
  if( l > ScratchSizeMax-sScratchTop ) {
    warning( "StackScratch::get( %ld ) returns NULL\n", l );
    return 0;
  }
  sScratchTop += l;
  mTotal += l;
  return &sScratch[ sScratchTop-l ];
}

