
#if !defined( textures_h )
#define textures_h


#include "glut-start.h"

struct GWState;
class InternalTexture;

class TextureRef
{
public:
  TextureRef( );
  TextureRef( char const * path );
  ~TextureRef( );
  TextureRef( TextureRef const & other );
  TextureRef & operator=( TextureRef const & other );

  bool operator==( TextureRef const & other ) const
            {
              return mTexture == other.mTexture;
            }
  bool operator!=( TextureRef const & other ) const
            {
              return !(mTexture == other.mTexture);
            }
  bool operator<( TextureRef const & other ) const;
  bool consistent( ) const;

  void getSize( int * xSize, int * ySize );
  void getInset( float * xInset, float * yInset );

  static TextureRef null;

private:
  friend class InternalTexture;
  friend void gwForceState( GWState const * );
  friend void gwSetState( GWState const * );
  InternalTexture * mTexture;
};


#endif  //  textures_h
