
#include "values.h"


class ValuesImp
{
  struct item {
    item *        next;
    char *        key;
    int           hash;
    char *        value;
    long          lValue;
    double        dValue;

    item( ) : next( 0 ), key( 0 ), value( 0 ), lValue( 0 ), dValue( 0 )
      {
      }
    ~item( )
      {
        free( key );
        free( value );
      }
    void setKey( char const * k, int h )
      {
        hash = h;
        int l = strlen( k )+1;
        key = (char *)realloc( key, l );
        memcpy( key, k, l );
      }
    void setValue( char const * v )
      {
        int l = strlen( v )+1;
        value = (char *)realloc( value, l );
        memcpy( value, v, l );
        char * out;
        lValue = strtol( v, &out, 10 );
        dValue = strtod( value, &out );
      }
  };
  item *        items[ 256 ];
public:
                ValuesImp( )
                  {
                    memset( items, 0, sizeof( items ) );
                  }
                ~ValuesImp( )
                  {
                    clear( );
                  }

  long          longValue( char const * name, long def )
                  {
                    item * i = lookup( name );
                    if( !i ) return def;
                    return i->lValue;
                  }
  double        doubleValue( char const * name, double def )
                  {
                    item * i = lookup( name );
                    if( !i ) return def;
                    return i->dValue;
                  }
  char const *  strValue( char const * name, char const * def )
                  {
                    item * i = lookup( name );
                    if( !i ) return def;
                    return i->value;
                  }

  void          setValue( char const * name, char const * value )
                  {
                    int h = hash( name );
                    item **i = &items[ h & 0xff ];
                    while( *i ) {
                      if( (h == (*i)->hash) && (!stricmp( (*i)->key, name )) ) {
                        goto set_value;
                      }
                      i = &(*i)->next;
                    }
                    *i = new item;
                    (*i)->setKey( name, h );
                  set_value:
                    (*i)->setValue( value );
                  }

  void          clear( )
                  {
                    for( int ix = 0; ix < 256; ++ix ) {
                      item *i = items[ ix ];
                      while( i ) {
                        item * d = i;
                        i = d->next;
                        delete d;
                      }
                    }
                    memset( items, 0, sizeof( items ) );
                  }


  int           hash( char const * name )
                  {
                    int h = 0;
                    if( !name ) return 0;
                    while( *name ) {
                      h = (h * 12345 + 6789) ^ tolower( *name );
                      ++name;
                    }
                    return h;
                  }
  item *        lookup( char const * name )
                  {
                    int h = hash( name );
                    item *i = items[ h & 0xff ];
                    while( i ) {
                      if( (h == i->hash) && (!stricmp( i->key, name )) ) {
                        return i;
                      }
                      i = i->next;
                    }
                    return 0;
                  }
};


Values::Values( )
{
  imp = new ValuesImp;
}

Values::~Values( )
{
  delete imp;
}

long
Values::longValue( char const * name, long def ) const
{
  return imp->longValue( name, def );
}

double
Values::doubleValue( char const * name, double def ) const
{
  return imp->doubleValue( name, def );
}

char const *
Values::strValue( char const * name, char const * def ) const
{
  return imp->strValue( name, def );
}

void
Values::setValue( char const * name, char const * value )
{
  imp->setValue( name, value );
}

void
Values::clear( )
{
  imp->clear( );
}

