
#if !defined( values_h )
#define values_h

#include "glut-start.h"

class Values
{
  class ValuesImp *   imp;
public:
                Values( );
                ~Values( );

  long          longValue( char const * name, long def = 0 ) const;
  double        doubleValue( char const * name, double def = 0.0 ) const;
  char const *  strValue( char const * name, char const * def = 0 ) const;

  void          setValue( char const * name, char const * value );

  void          clear( );

  char const *  operator()( char const * name, char const * def ) const
                  {
                    return strValue( name, def );
                  }
  long          operator()( char const * name, long def ) const
                  {
                    return longValue( name, def );
                  }
  long          operator()( char const * name, int def ) const
                  {
                    return longValue( name, def );
                  }
  double        operator()( char const * name, double def ) const
                  {
                    return doubleValue( name, def );
                  }
};


#endif  //  values_h
